<?php
namespace ILC\AdminUsuarios\Traits;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use App\Models\User;
use Illuminate\Http\Request;

trait RollablePermissionable {

    /**
     * Asigna roles y permisos al usuario
     *
     * @param User $user
     * @param Request $request
     * @return void
     */
    protected function assignRolesAndPermissions(User $user, Request $request): void
    {
        if($request->filled('roles')) {
            $user->syncRoles([$request->roles]);
        }

        $user->syncPermissions([ $request->get('permisos',[]) ]);
    }

}
