<?php

namespace ILC\AdminUsuarios\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class ILCUserImports extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;



    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'user_imports';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'file_name',
        'total_records_in_file',
        'records_added',
        'records_updated',
        'records_with_errors',
        'errors_detail'
    ];


    /**
     * {@inheritdoc}
     */
    public function generateTags(): array
    {
        return [
            $this->file_name . '_' . $this->created_at->format('YmdHis'),
        ];
    }

}
