<?php
namespace ILC\AdminUsuarios\Http\Requests;

use Illuminate\Support\Facades\Lang;

class CreateUsersWithCertificatesRequest extends FormRequest {

    protected $stopOnFirstFailure = true;

    /**
     * Determina si el usuario está autorizado para hacer la petición.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return auth()->user()->hasPermissionTo('crear-usuarios-por-certificado');
    }


    /**
     * Las reglas de validación para crear usuarios
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'certificados.*' => 'required|file',
        ];
    }


    /**
     * Las traducciones de las reglas
     *
     * @return array
     */
    public function messages(): array
    {
        return trans("adminusuarios::validation.custom.certificados");
    }


    /**
     * Las traducciones de los atributos a validar
     *
     * @return array
     */
    public function attributes(): array
    {
        return trans("adminusuarios::validation.attributes");
    }
}
