<?php


namespace ILC\AdminUsuarios\Exports;

use ILC\AdminUsuarios\Traits\UserQueryTrait;
use Illuminate\Http\Request;

class UsersExport
{
    use UserQueryTrait;

    protected Request $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function exportData()
    {
//        if (!$this->hasPermission('exportar-usuarios')) {
//            throw new AuthorizationException();
//        }

        $usersQuery = $this->buildUsersQuery($this->request);

        if ($this->request->filled('role')) {
            $usersQuery->where('roles.name', $this->request->role);
        }

        if ($this->request->filled('status')) {
            $usersQuery->where('estado', filter_var($this->request->status, FILTER_VALIDATE_BOOLEAN));
        }

        if ($this->request->filled('search')) {
            $search = $this->request->search;
            $usersQuery->where(function ($query) use ($search) {
                $query->where('nombre', 'ilike', "%$search%")
                    ->orWhere('primer_apellido', 'ilike', "%$search%")
                    ->orWhere('segundo_apellido', 'ilike', "%$search%")
                    ->orWhere('email', 'ilike', "%$search%")
                    ->orWhere('curp', 'ilike', "%$search%")
                    ->orWhere('serie', 'ilike', "%$search%");
            });
        }

        $this->applySorting($usersQuery, $this->request);

        foreach ($usersQuery->cursor() as $user) {
            yield $user;
        }
    }
}
