<?php

namespace ILC\AdminUsuarios\Exceptions;

use Exception;
use Illuminate\Http\JsonResponse;

class CertificateReadException extends Exception
{
    public function __construct($message = 'Ocurrió un error en la lectura del certificado', $code = 422)
    {
        parent::__construct($message, $code);
    }

    public function render(): JsonResponse
    {
        return response()->json([
            'success' => false,
            'code' => $this->getCode(),
            'result' => array('message' => $this->getMessage()),
        ], $this->getCode());
    }
}
