<?php

namespace ILC\AdminUsuarios\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $guards = ['web'];

        // listado de permisos
        $permissions = [
            'visualizar-usuarios',
            'creacion-de-usuarios',
            'crear-usuarios',
            'edicion-de-usuarios',
            'eliminacion-de-usuarios',
            'edicion-masiva-de-usuarios',
            'crear-usuarios-por-certificado',
            'crear-usuarios-por-xlsx'
        ];

        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // inserta permisos
        foreach ($guards as $guard_name) {
            foreach ($permissions as $permission) {
                Permission::firstOrCreate([
                    'name' => $permission,
                    'guard_name' => $guard_name,
                ]);
            }
        }

        //crea el rol para el super usuario y le asigna permisos
        $role = Role::firstOrCreate(['name' => 'Super usuario']);
        $permissions = Permission::pluck('id','id')->all();
        $role->permissions()->syncWithoutDetaching($permissions);

        // Si el ambiente es local entonces asignamos al usuario default los permisos
        if (app()->environment('local')) {

            $user = User::firstOrCreate(
                ['email' => 'admin@teclab.mx'],
                [
                    'name' => 'Super usuario',
                    'password' => 'password'
                ]
            );

            $user->perfil()->firstOrCreate(
                ['curp' => 'XEXX010101HNEXXXA4'],
                [
                    'nombre' => 'Super usuario',
                    'primer_apellido' => 'General',
                    'segundo_apellido' => ''
                ]);

            // asigna permisos
            $user->assignRole([$role->id]);
            $user->givePermissionTo($permissions);
        }
    }
}
