<?php

namespace ILC\AdminUsuarios\Database\Factories;

use ILC\AdminUsuarios\Models\Perfil;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Cache;

class PerfilFactory extends Factory
{
    protected $model = Perfil::class;

    public function definition()
    {
        $persona = fake()->persona();
        return [
            'nombre' => $persona->nombre,
            'primer_apellido' => $persona->apellido1,
            'segundo_apellido' => $persona->apellido2,
            'curp' => $persona->curp,
            'certificado' => $this->faker->md5(),
            'serie' => $this->faker->bothify('??###'),
            'estado' => $this->faker->randomElement([true, false]),
            'autenticacion' => 'default'
        ];
    }
}
