<?php

namespace ILC\AdminUsuarios\Traits;

use ILC\AdminUsuarios\Models\ILCUser;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

trait UserQueryTrait {

    public function buildUsersQuery(Request $request)
    {
        return ILCUser::select('users.id', 'users.nombre', 'users.primer_apellido', 'users.segundo_apellido', 'users.email', 'users.estado', 'users.autenticacion', 'users.curp', 'users.serie', 'users.estado')
            ->selectRaw("
            CASE
                WHEN COUNT(DISTINCT roles.name) = 0 THEN ''
                ELSE STRING_AGG(DISTINCT roles.name, ',')
            END as roles
        ")
            ->leftJoin('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')
            ->leftJoin('roles', 'model_has_roles.role_id', '=', 'roles.id')
            ->groupBy('users.id', 'users.nombre', 'users.primer_apellido', 'users.segundo_apellido', 'users.email', 'users.estado', 'users.autenticacion', 'users.curp', 'users.serie', 'users.estado');
    }

    public function applySorting($query, Request $request): void
    {
        $sortFields = $request->input('filter.sort');

        if ($request->filled('filter.sort')) {
            foreach (explode(',', $sortFields) as $sortField) {
                $direction = Str::startsWith($sortField, '-') ? 'desc' : 'asc';
                $field = ltrim($sortField, '-');

                if ($field === 'roles') {
                    $query->orderByRaw("
                    CASE
                        WHEN COUNT(DISTINCT roles.name) = 0 THEN ''
                        ELSE STRING_AGG(DISTINCT roles.name, ',')
                    END " . $direction
                    );
                } else {
                    $query->orderBy($field, $direction);
                }
            }
        } else {
            $order = Str::of($request->get('order', 'users.id,desc'))->split('/[\s,|]+/');
            $query->orderBy($order->first(), $order->last());
        }
    }
}
