<?php

namespace ILC\AdminUsuarios\Providers;

use ILC\AdminUsuarios\Auth\ILCAuthProviderDriver;
use ILC\AdminUsuarios\Auth\Strategies\LDAPAuthStrategy;
use ILC\AdminUsuarios\Http\Middleware\ILCAuthMiddleware;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\ServiceProvider;
use ILC\AdminUsuarios\Auth\AuthManagerContext;
use ILC\AdminUsuarios\Auth\Contracts\AuthStrategyInterface;
use ILC\AdminUsuarios\Auth\Strategies\DefaultAuthStrategy;
use ILC\AdminUsuarios\Auth\Strategies\CertificadoAuthStrategy;
use ILC\AdminUsuarios\Auth\Strategies\ApiAuthStrategy;

class ILCAuthServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(AuthManagerContext::class, function ($app) {
            return new AuthManagerContext();
        });

        $this->app->singleton(ILCAuthMiddleware::class, function ($app) {
            return new ILCAuthMiddleware($app->make(AuthManagerContext::class));
        });

        if (!$this->app->routesAreCached()) {
            if (!$this->app->routesAreCached()) {
                require __DIR__.'/../../routes/web.php';
            }

            if (!$this->app->routesAreCached()) {
                require __DIR__.'/../../routes/api.php';
            }
        }

    }

    public function boot(Router $router): void
    {
        Auth::provider('ilc_auth_provider_driver', function ($app, array $config) {
            return new ILCAuthProviderDriver($app['hash'], $config['model']);
        });

        $this->publishes([
            __DIR__.'/../../config/auth.php' => config_path('auth.php'),
        ]);

        $this->mergeConfigFrom(
            __DIR__.'/../../config/auth.php', 'auth'
        );

        $authConfig = require __DIR__.'/../../config/auth.php';

        Config::set('auth.providers.users', array_merge(
            Config::get('auth.providers.users', []),
            $authConfig['providers']['users']
        ));

        Config::set('auth.guards.web', array_merge(
            Config::get('auth.guards.web', []),
            $authConfig['guards']['web']
        ));

        Config::set('app.locale', 'es');
        Config::set('app.fallback_locale', 'es');

        $router->aliasMiddleware('ilc.auth', ILCAuthMiddleware::class);
    }
}
