<?php

namespace ILC\AdminUsuarios\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserFilterResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->id,
            'nombre' => $this->nombre . (strlen($this->primer_apellido) == 0 ? '' : ' '.$this->primer_apellido) . (strlen($this->segundo_apellido) == 0 ? '' : ' '.$this->segundo_apellido),
            'email' => $this->email,
            'roles' => $this->roles->pluck('name')->join(','),
            'estado' => $this->estado ? 'activo' : 'inactivo',
            'autenticacion' => $this->autenticacion,
        ];
    }
}
