<?php

namespace ILC\AdminUsuarios\Http\Middleware;

use Closure;
use ILC\AdminUsuarios\Auth\AuthManagerContext;
use ILC\AdminUsuarios\Auth\Contracts\AuthStrategyInterface;
use Illuminate\Http\Request;

use ILC\AdminUsuarios\Auth\Strategies\ApiAuthStrategy;
use ILC\AdminUsuarios\Auth\Strategies\CertificadoAuthStrategy;
use ILC\AdminUsuarios\Auth\Strategies\DefaultAuthStrategy;
use ILC\AdminUsuarios\Auth\Strategies\LDAPAuthStrategy;

class ILCAuthMiddleware {
    protected AuthManagerContext $authManager;
    protected AuthStrategyInterface $strategy;

    public function __construct(AuthManagerContext $authManager) {
        $this->authManager = $authManager;
    }

    public function handle(Request $request, Closure $next, $guard = null )
    {
        if($request->path() == 'api/login'){
            $output = match (true) {
                $request->filled(['firma']) => $this->authManager->setStrategy(new certificadoAuthStrategy()),
                $request->filled(['email', 'password']) && $request->header('X-XSRF-TOKEN') => $this->authManager->setStrategy(new DefaultAuthStrategy()),
                $request->filled(['email', 'password']) && !$request->header('X-XSRF-TOKEN')=> $this->authManager->setStrategy(new ApiAuthStrategy()),
                $request->filled(['param1', 'param2']) => $this->authManager->setStrategy(new LDAPAuthStrategy()),
                default => throw new \InvalidArgumentException('No se puede autentificar con los datos proporcionados.'),
            };
        }

        return $next($request);


    }
}
