<?php

namespace ILC\AdminUsuarios\Traits;

use ILC\AdminUsuarios\Models\ILCUser;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

trait UserQueryTrait {
    public function buildUsersQuery(Request $request)
    {
        return ILCUser::select(
            'users.id',
            'users.nombre',
            'users.primer_apellido',
            'users.segundo_apellido',
            'users.email',
            'users.estado',
            'users.autenticacion',
            'users.curp',
            'users.serie',
            'users.estado'
        )
            ->leftJoin('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')
            ->leftJoin('roles', 'model_has_roles.role_id', '=', 'roles.id')
            ->selectRaw("STRING_AGG(DISTINCT roles.name, ', ' ORDER BY roles.name ASC) as roles")
            ->groupBy(
                'users.id',
                'users.nombre',
                'users.primer_apellido',
                'users.segundo_apellido',
                'users.email',
                'users.estado',
                'users.autenticacion',
                'users.curp',
                'users.serie',
                'users.estado'
            );

    }

    public function applySorting($query, Request $request): void
    {
        $sortFields = $request->input('filter.sort');

        if ($request->filled('filter.sort')) {
            foreach (explode(',', $sortFields) as $sortField) {
                $direction = Str::startsWith($sortField, '-') ? 'desc' : 'asc';
                $field = ltrim($sortField, '-');

                if ($field === 'roles') {
                    $query->orderByRaw("STRING_AGG(DISTINCT roles.name, ',') " . $direction);
                } else {
                    $query->orderBy($field, $direction);
                }
            }
        } else {
            $order = Str::of($request->get('order', 'users.id,desc'))->split('/[\s,|]+/');
            $query->orderBy($order->first(), $order->last());
        }
    }
}
