<?php

namespace ILC\AdminUsuarios\Models;

use Spatie\Permission\Traits\HasRoles;
use OwenIt\Auditing\Contracts\Auditable;
use App\Models\User as BaseUser;
use Laravel\Sanctum\HasApiTokens;
use OwenIt\Auditing\Redactors\LeftRedactor;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ILCUser extends BaseUser implements Auditable
{
    use HasRoles;
    use HasApiTokens;
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    protected $guard_name = 'web';

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'users';

    /**
     * Default values for attributes.
     *
     * @var array<int, string>
     */
    protected $attributes = array(
        'estado' => true,
        'autenticacion' => 'default'
    );

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nombre',
        'email',
        'password',
        'primer_apellido',
        'segundo_apellido',
        'curp',
        'certificado',
        'serie',
        'autenticacion',
        'estado'
    ];

    protected static function newFactory()
    {
        if (!app()->environment('production')) {
            return \ILC\AdminUsuarios\Database\Factories\UserFactory::new();
        }
        return null;
    }

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    /**
     * Attribute modifiers.
     *
     * @var array
     */
    protected $attributeModifiers = [
        'password' => LeftRedactor::class,
    ];


    /**
     * {@inheritdoc}
     */
    public function generateTags(): array
    {
        return [
            $this->email,
        ];
    }

    /**
     * Attributes to exclude from the Audit.
     *
     * @var array
     */
    protected $auditExclude = [
        'email_verified_at',
        'remember_token'
    ];
}
