<?php

namespace ILC\AdminUsuarios\Listeners;

use ILC\AdminUsuarios\Events\UsuarioCreado;
use ILC\AdminUsuarios\Events\UsuarioEditado;
use ILC\AdminUsuarios\Events\UsuarioEliminador;
use ILC\AdminUsuarios\Events\ContrasenaTemporal;
use ILC\AdminUsuarios\Mail\UsuarioCreadoMailable;
use ILC\AdminUsuarios\Mail\ContrasenaTemporalMailable;
use Illuminate\Events\Dispatcher;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class UsuarioEventSubscriber
{
    public function handleUsuarioCreado(UsuarioCreado $event): void {
        Mail::to($event->user->email)->send(new UsuarioCreadoMailable($event->user, $event->tempPassword));
    }

    public function handleUsuarioEditado(UsuarioEditado $event): void {
        Log::info('Usuario Editado Handle: '.$event->user);
        //Mail::to($event->user->email)->send(new UsuarioCreadoMailable($event->user, $event->tempPassword));
    }

    public function handleUsuarioEliminado(UsuarioEliminado $event): void {
        Log::info('Usuario Eliminado Handle: '.$event->user);
        //Mail::to($event->user->email)->send(new UsuarioCreadoMailable($event->user, $event->tempPassword));
    }

    public function handleContrasenaTemporal(ContrasenaTemporal $event): void {
        Mail::to($event->user->email)->send(new ContrasenaTemporalMailable($event->user, $event->tempPassword));
    }

    public function subscribe(Dispatcher $events): array {
        return [
            UsuarioCreado::class => 'handleUsuarioCreado',
            UsuarioEditado::class => 'handleUsuarioEditado',
            UsuarioEliminado::class => 'handleUsuarioEliminado',
            ContrasenaTemporal::class => 'handleContrasenaTemporal',
        ];
    }
}
