<?php
namespace ILC\AdminUsuarios\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
// use Illuminate\Validation\ValidationException;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Foundation\Http\FormRequest as BaseFormRequest;
use ILC\AdminUsuarios\Exceptions\AuthorizationException;

class FormRequest extends BaseFormRequest
{
    protected function failedValidation(Validator $validator): void
    {
        // if ($this->expectsJson()) {
        throw new HttpResponseException(
            response()->json([
                'success' => false,
                'code' => 422,
                'result' => array('message' =>  $this->validator->errors()->first())
            ]
        ));
        // } else {
        //     parent::failedValidation($validator);
        // }
    }

    protected function failedAuthorization()
    {
        throw new AuthorizationException();
    }
}
