<?php

namespace ILC\AdminUsuarios\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use ILC\AdminUsuarios\Models\ILCUser;

class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $guards = ['web'];

        // listado de permisos
        $permissions = [
            'visualizar-usuarios',
            'creacion-de-usuarios',
            'edicion-de-usuarios',
            'eliminacion-de-usuarios',
            'edicion-masiva-de-usuarios',
            'crear-usuarios-por-certificado',
            'crear-usuarios-por-xlsx'
        ];

        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // inserta permisos
        foreach ($guards as $guard_name) {
            foreach ($permissions as $permission) {
                Permission::firstOrCreate([
                    'name' => $permission,
                    'guard_name' => $guard_name,
                ]);
            }
        }

        //crea el rol para el super usuario y le asigna permisos
        $role = Role::firstOrCreate(['name' => 'Super usuario']);
        $permissions = Permission::pluck('id', 'id')->all();
        $role->syncPermissions($permissions);

        // Si el ambiente es local entonces asignamos al usuario default los permisos
        if (app()->environment('local')) {

            // Encuentra al usuario al que deseas asignar los permisos
            $user = ILCUser::find(1);

            // asigna permisos
            $user->assignRole([$role->id]);
            $user->givePermissionTo($permissions);
        }
    }
}
