<?php

namespace ILC\AdminUsuarios\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

use ILC\AdminUsuarios\Models\ILCUser;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<ILCUser>
 */
class UserFactory extends Factory
{
    /**
     * The current password being used by the factory.
     */
    protected static ?string $password;
    protected $model = ILCUser::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $persona = fake()->persona();

        return [
            'nombre' => $persona->nombre,
            'email' => strtolower(Str::random(6)."@".Str::random(5))."xmail.com",
            'primer_apellido' => $persona->apellido1,
            'segundo_apellido' => $persona->apellido2,
            'curp' => $persona->curp,
            'certificado' => '',
            'serie' => '',
            'estado' => array_rand([0,1]),
            'autenticacion' => 'default',
            'email_verified_at' => now(),
            'password' => static::$password ??= Hash::make('password'),
            'remember_token' => Str::random(10),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     */
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }

    /**
     * Assign a random role to the user after creation.
     */
    public function configure(): static
    {
        return $this->afterCreating(function (ILCUser $user) {
            $roles = Role::all()->pluck('name')->toArray();
            //dd($roles[array_rand($roles)]);
            if (!empty($roles)) {
                $user->assignRole($roles[array_rand($roles)]); // Asignar un rol aleatorio
            }
        });
    }

}
