<?php

namespace ILC\AdminUsuarios\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Log;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->id,
            'nombre' => data_get($this, 'perfil.nombre',''),
            'name' => trim(data_get($this, 'perfil.nombre','')." ".data_get($this, 'perfil.primer_apellido','')." ".data_get($this, 'perfil.segundo_apellido','')),
            'primer_apellido' => $this->perfil->primer_apellido,
            'segundo_apellido' => $this->perfil->segundo_apellido,
            'curp' => $this->perfil->curp,
            'email' => $this->email,
            'serie' => $this->perfil->serie,
            'estado' => $this->perfil->estado,
            'autenticacion' => $this->perfil->autenticacion,
            'roles' => empty($this->roles)?[]:$this->roles->pluck('name')->toArray(),
            'permisos' => empty($this->permissions)?[]:$this->permissions->pluck('name')->toArray(),

        ];
    }
}
