<?php

namespace ILC\AdminUsuarios\Http\Requests;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Validation\Validator;

class UpdateUserMassiveRequest extends FormRequest
{
    protected $stopOnFirstFailure = true;
    protected $rules = array();

    /**
     * Determina si el usuario está autorizado para hacer la petición.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->hasPermissionTo('edicion-masiva-de-usuarios');
    }

    /**
     * Procesa campos antes de validarlos
     *
     * @return void
     */
    protected function prepareForValidation(): void
    {
        $this->rules['action'] = 'required|in:roles,statusses,delete';
        $this->rules['users.*.id'] = 'sometimes|exists:users,id|exists:model_has_roles,model_id|not_in:1';
        if($this->action == 'roles'){
            $this->rules['roles'] = 'required_if:action,roles|exists:roles,name';
        }
        if($this->action == 'statusses'){
            $this->rules['statusses'] = 'required_if:action,statusses|boolean';
        }
    }

    /**
     * Las reglas de validación para crear usuarios
     *
     * @return array
     */
    public function rules(): array
    {
        return $this->rules;
    }

    /**
     * Las traducciones de las reglas
     *
     * @return array
     */
    public function messages(): array
    {
       return trans("adminusuarios::validation");
    }

    /**
     * Las traducciones de los atributos a validar
     *
     * @return array
     */
    public function attributes(): array
    {
        return trans("adminusuarios::validation.attributes");
    }
}
