<?php

namespace EdgarOrozco\LaravelMailconfig\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class BaseController
{
    /**
     * Generate the appropriate response based on the request type.
     *
     * @return JsonResponse|View
     */
    protected function respond(Request $request, array $data, string $view)
    {
        if ($request->is('api/*')) {
            return response()->json($data);
        }

        return view($view, $data);
    }
}
