@extends('layout.app')
@section('content')

    <!-- begin page-header -->
    <h1 class="page-header">{{__('Mail configuration admin')}}</h1>
    <!-- end page-header -->

    @if(!$is_enabled)
    <div class="alert alert-danger">
        <h3>{{__('NO ENABLED CONFIGURATION DETECTED, PLEASE ENABLE ONE CONFIGURATION')}}</h3>
    </div>
    @endif

    <!-- begin panel -->
    <div class="panel panel-default">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <h4 class="panel-title">{{__('Configuration data')}}</h4>
            <div class="panel-heading-btn">
                <a href="{!! action([\EdgarOrozco\LaravelMailconfig\Http\Controllers\MailConfigController::class, 'index']) !!}" class="btn btn-primary">
                    <i class="fa fa-plus-circle"></i> {{__('New configuration')}}
                </a>
            </div>
        </div>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            @include('mailconfig::_form')
        </div>
    </div>

    @if(count($configs))
    <div class="panel panel-default">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <h4 class="panel-title">{{__('Configurations list')}}</h4>
        </div>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            @include('mailconfig::_list')
        </div>
    </div>
    @endif
@endsection
