<table class="table table-striped table-bordered table-condensed table-td-valign-middle dataTable no-footer dtr-inline">
    <thead>
        <tr>
            <th scope="col">{{__('Name')}}</th>
            <th scope="col">{{__('Description')}}</th>
            <th scope="col">{{__('From Address')}}</th>
            <th scope="col">{{__('From Name')}}</th>
            <th scope="col">{{__('Driver')}}</th>
            <th scope="col">{{__('Host')}}</th>
            <th scope="col">{{__('Port')}}</th>
            <th scope="col">{{__('Encryption')}}</th>
            <th scope="col">{{__('Enabled')}}</th>
            <th scope="col">{{__('Actions')}}</th>
        </tr>
    </thead>
    <tbody>
    @foreach($configs as $idx => $cfg)
        <tr class="{{($idx % 2 == 0) ? 'odd' : 'even'}}">
            <td scope="row" title="{{strlen($cfg->name) > 20 ? $cfg->name : ''}}">{{Str::limit($cfg->name, 20, '...')}}</td>
            <td title="{{strlen($cfg->descripcion) > 20 ? $cfg->description : ''}}">{{Str::limit($cfg->description, 20, '...')}}</td>
            <td>{{$cfg->from_address}}</td>
            <td>{{$cfg->from_name}}</td>
            <td>{{$cfg->driver}}</td>
            <td>{{$cfg->host}}</td>
            <td>{{$cfg->port}}</td>
            <td>{{mb_strtoupper($cfg->encryption)}}</td>
            <td><div class="rounded-circle {{$cfg->enabled ? 'bg-success':'bg-danger'}} mx-auto" style="width: 10px; height: 10px;"></div></td>
            <td nowrap>
                {!! Form::open(['action' => ['\EdgarOrozco\LaravelMailconfig\Http\Controllers\MailConfigController@index', $cfg->id], 'method'=>'DELETE']) !!}
                <div style="display: inline-block;">
                    <a class="btn btn-xs btn-primary" href="{{action([\EdgarOrozco\LaravelMailconfig\Http\Controllers\MailConfigController::class, 'index'],['id'=>$cfg->id])}}"><i class="fa fa-pencil-alt"></i></a>

                    <a href="javascript:void(0);" class="btn btn-xs btn-primary btn-borrar">
                        <i class="fa fa-trash btn-borrar text-warning"></i>
                    </a>
                </div>
                {!! Form::close() !!}
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
