<?php

use EdgarOrozco\LaravelMailconfig\Http\Controllers\MailConfigController;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Middleware\PermissionMiddleware;

Route::middleware('auth:sanctum')->group(function () {

    Route::prefix('api/mailconfig')
        ->middleware('api')
        ->group(function () {

            Route::get('/', [MailConfigController::class, 'index'])
                ->middleware(PermissionMiddleware::class.':listar-mailconfig');

            Route::post('/', [MailConfigController::class, 'update'])
                ->middleware(PermissionMiddleware::class.':editar-mailconfig')
                ->middleware(PermissionMiddleware::class.':crear-mailconfig');

            Route::delete('/', [MailConfigController::class, 'destroy'])
                ->middleware(PermissionMiddleware::class.':borrar-mailconfig');
        });

});
