<?php

namespace EdgarOrozco\LaravelMailconfig\Traits;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;

trait Filterable
{
    public function scopeFilter($query, array $filters)
    {
        foreach ($filters as $field => $value) {
            if ($field == 'sort') {
                $this->applySort($query, $value);
            } else {
                if (strpos($field, '.') !== false) {
                    [$relation, $field] = explode('.', $field);
                    $query->whereHas($relation, function (Builder $query) use ($field, $value) {
                        $this->applyFilter($query, $field, $value);
                    });
                } else {
                    $this->applyFilter($query, $field, $value);
                }
            }
        }

        return $query;
    }

    protected function applyFilter(Builder $query, $field, $value)
    {
        $operators = [
            '>' => '>',
            '<' => '<',
            '=' => '=',
        ];

        $operator = '=';

        foreach ($operators as $symbol => $op) {
            if (strpos($value, $symbol) === 0) {
                $operator = $op;
                $value = substr($value, strlen($symbol));
                break;
            }
        }

        if (strpos($value, ',') !== false) {
            $values = explode(',', $value);
            $query->whereIn($field, $values);
        } elseif (strpos($value, '%') !== false) {
            $query->where(DB::raw("unaccent($field)"), 'ILIKE', DB::RAW("unaccent('$value')"));
        } else {
            $query->where($field, $operator, $value);
        }
    }

    protected function applySort(Builder $query, $value)
    {

        $sortFields = explode(',', $value);

        foreach ($sortFields as $sortField) {
            $direction = 'asc';

            if (strpos($sortField, '-') === 0) {
                $direction = 'desc';
                $sortField = substr($sortField, 1);
            }

            $query->orderBy($sortField, $direction);
        }
    }
}
