<?php

namespace EdgarOrozco\LaravelMailconfig\Providers;

use EdgarOrozco\LaravelMailconfig\Listeners\MessageSendingListener;
use EdgarOrozco\LaravelMailconfig\Listeners\MessageSentListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Mail\Events\MessageSending;
use Illuminate\Mail\Events\MessageSent;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        MessageSent::class => [
            MessageSentListener::class,
        ],
        MessageSending::class => [
            MessageSendingListener::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
    }
}
