<?php

namespace EdgarOrozco\LaravelMailconfig\Actions;

use EdgarOrozco\LaravelMailconfig\Models\MailConfig;

class DisableExistingConfigIfEnabled
{
    protected $countEnabledConfigs;

    public function __construct(CountEnabledConfigs $countEnabledConfigs)
    {
        $this->countEnabledConfigs = $countEnabledConfigs;
    }

    public function __invoke($enabled)
    {
        $enabled = filter_var($enabled, FILTER_VALIDATE_BOOLEAN);
        if ($enabled && ($this->countEnabledConfigs)()) {
            MailConfig::whereEnabled(true)->update(['enabled' => false]);
        }
    }
}
