// Plugins
import vue from '@vitejs/plugin-vue'
import vuetify from 'vite-plugin-vuetify'
import AutoImport from 'unplugin-auto-import/vite'
import ViteFonts from 'unplugin-fonts/vite'
import fs from 'fs';
import path from 'path';

// Utilities
import { defineConfig } from 'vite'
import { fileURLToPath, URL } from 'node:url'

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    vue({
      template: {
        transformAssetUrls: {
          base: null,
          includeAbsolute: false,
        }
      },
    }),
    // https://github.com/vuetifyjs/vuetify-loader/tree/next/packages/vite-plugin
    vuetify({
      //autoImport: true,
      styles: {
        configFile: './styles/vuetify/_variables.scss',
      },
    }),
    ViteFonts({
      google: {
        families: [{
          name: 'Roboto',
          styles: 'wght@100;300;400;500;700;900',
        }],
      },
    }),
    AutoImport({
      eslintrc: {
        enabled: true,
        filepath: './.eslintrc-auto-import.json',
      },
      imports: ['vue', 'vue-router'],
      vueTemplate: true,
    }),
    {
      name: 'clean-old-assets',
      buildStart() {
        const assetsPath = path.resolve(__dirname, '../../public/assets');
        const comunesPath = path.resolve(__dirname, '../../public/assets/comunes');

        // Limpia solo los archivos en assets y comunes
        if (fs.existsSync(assetsPath)) {
          fs.readdirSync(assetsPath).forEach(file => {
            if (file !== 'comunes') {
              fs.unlinkSync(path.join(assetsPath, file));
            }
          });
        }

        if (fs.existsSync(comunesPath)) {
          fs.readdirSync(comunesPath).forEach(file => {
            fs.unlinkSync(path.join(comunesPath, file));
          });
        }
      }
    }
  ],
  //define: { 'process.env': {} },
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./js/', import.meta.url)),
      '@app': fileURLToPath(new URL('./app/', import.meta.url)),
      '@styles': fileURLToPath(new URL('./styles/', import.meta.url)),
      '@appConfig': fileURLToPath(new URL('./appConfig.js', import.meta.url)),
    },
    extensions: [
      '.js',
      '.json',
      '.jsx',
      '.mjs',
      '.ts',
      '.tsx',
      '.vue',
    ],
  },
  server: {
    port: 3000,
  },
  // Opciones de Building MUY IMPORTANTE PARA TRABAJAR CON PAQUETES
  base: '/', // Establece la base URL para que las rutas apunten a /front/assets/
  build: {
    minify: false, // Para efectos de revisión del código no minificado
    outDir: '../../public/',  // Establece la salida principal en public/front
    assetsDir: 'assets',           // Los assets se colocarán en public/front/assets
    rollupOptions: {
      output: {
        entryFileNames: 'assets/[name].[hash].js',
        chunkFileNames: 'assets/[name].[hash].js',
        assetFileNames: 'assets/comunes/[name].[hash][extname]',
      },
    },
    manifest: true,  // Genera un manifiesto para saber dónde están los archivos
  },
  optimizeDeps: {
    exclude: ['vuetify'],
    entries: [
      './src/**/*.vue',
    ],
  },

})
