const fs = require('fs');
const dotenv = require('dotenv');

const envConfig = dotenv.parse(fs.readFileSync('.env.production'));

envConfig['VITE_BUILD_TIME'] = new Date().toLocaleString();

fs.writeFileSync('.env.production', Object.entries(envConfig).map(([key, value]) => `${key}=${value}`).join('\n'));

console.log(`Build time set to: ${envConfig['BUILD_TIME']}`);