<?php

namespace EdgarOrozco\LaravelMailconfig\Services;

use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;

class PermissionService
{
    public function createPermissions(array $permissions, array $guards = ['web']): void
    {
        foreach ($guards as $guard_name) {
            foreach ($permissions as $permission) {
                if (Schema::hasColumns('permissions', ['description', 'modulo'])) {
                    Permission::firstOrCreate([
                        'name' => $permission['name'],
                        'guard_name' => $guard_name,
                        'description' => $permission['description'],
                        'modulo' => $permission['modulo'],
                    ]);
                } else {
                    Permission::firstOrCreate([
                        'name' => $permission['name'],
                        'guard_name' => $guard_name,
                    ]);
                }
            }
        }
    }

    public function getPermissions(): array
    {
        return [
            ['name' => 'listar-mailconfig', 'description' => 'Listar las configuraciones de correo saliente', 'modulo' => 'Mail Config'],
            ['name' => 'crear-mailconfig', 'description' => 'Crear configuraciones de correo saliente', 'modulo' => 'Mail Config'],
            ['name' => 'editar-mailconfig', 'description' => 'Editar configuraciones de correo saliente', 'modulo' => 'Mail Config'],
            ['name' => 'borrar-mailconfig', 'description' => 'Eliminar configuraciones de correo saliente', 'modulo' => 'Mail Config'],
        ];
    }
}
