<?php

namespace EdgarOrozco\LaravelMailconfig\Actions;

use Illuminate\Http\Request;

class ValidateMailConfigRequest
{
    public function __invoke(Request $request)
    {

        $rules_name = ['required', 'min:5', 'max:60', 'iunique:mail_configs,name'];
        if ($request->has('id') && $request->input('id')) {
            $rules_name = ['required', 'min:5', 'max:60', 'iunique:mail_configs,name,id,'.$request->input('id')];
        }

        $rules = [
            'name' => $rules_name,
            'description' => ['required', 'min:5', 'max:500'],
            'driver' => 'required',
            'host' => ['required', 'min:5', 'max:200', 'regex:/^(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\.)+(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)$/'],
            'port' => 'required|integer',
            'username' => ['required', 'max:250'],
            'password' => ['required', 'max:250'],
            'encryption' => 'required|in:tls,ssl,TLS,SSL,ssh,SSH,plain,PLAIN',
            'from_address' => ['required', 'email', 'max:200'],
            'from_name' => ['required', 'max:200'],
            'enabled' => 'required',
        ];

        $messages = [
            'host.min' => __('mailconfig::validation.host.min'),
            'host.max' => __('mailconfig::validation.host.max'),
            'host.regex' => __('mailconfig::validation.host.regex'),
            'username.max' => __('mailconfig::validation.username.max'),
            'password.max' => __('mailconfig::validation.password.max'),
            'from_address.max' => __('mailconfig::validation.from_address.max'),
            'from_name.max' => __('mailconfig::validation.from_name.max'),
            'name.required' => __('mailconfig::validation.name.required'),
            'name.min' => __('mailconfig::validation.name.min'),
            'name.max' => __('mailconfig::validation.name.max'),
            'name.iunique' => __('mailconfig::validation.name.unique'),
            'description.required' => __('mailconfig::validation.description.required'),
            'description.min' => __('mailconfig::validation.description.min'),
            'description.max' => __('mailconfig::validation.description.max'),
            'driver.required' => __('mailconfig::validation.driver.required'),
            'host.required' => __('mailconfig::validation.host.required'),
            'port.required' => __('mailconfig::validation.port.required'),
            'port.integer' => __('mailconfig::validation.port.integer'),
            'username.required' => __('mailconfig::validation.username.required'),
            'password.required' => __('mailconfig::validation.password.required'),
            'encryption.required' => __('mailconfig::validation.encryption.required'),
            'encryption.in' => __('mailconfig::validation.encryption.in'),
            'from_address.required' => __('mailconfig::validation.from_address.required'),
            'from_address.email' => __('mailconfig::validation.from_address.email'),
            'from_name.required' => __('mailconfig::validation.from_name.required'),
            'enabled.required' => __('mailconfig::validation.enabled.required'),
        ];

        $request->validate($rules, $messages);
    }
}
