<form action="{{ action([\EdgarOrozco\LaravelMailconfig\Http\Controllers\MailConfigController::class, 'index']) }}" method="post">
    @csrf
    <div class="row">
        <div class="col-4">
            <div class="form-group">
                <label for="nombre">{{__('Name')}} <span class="text-danger">*</span></label>
                <input type="text" name="name" id="name" value="{{ old('name', $config->name ?? null) }}"
                       class="form-control">
                <small class="form-text text-muted">{{__('Name to identify the configuration')}}</small>
            </div>
        </div>
        <div class="col-8">
            <div class="form-group">
                <label for="description">{{__('Description')}}</label>
                {!! Form::textarea('description', old('description', $config->description ?? null), ['class' => 'form-control', 'rows' => 5]) !!}
                <small class="form-text text-muted">{{__('Description of the configuration')}}</small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-3">
            <div class="form-group">
                <label for="driver">Driver <span class="text-danger">*</span></label>
                <input type="text" name="driver" id="driver" value="{{ old('driver', $config->driver ?? null) }}" class="form-control">
                <small class="form-text text-muted">{{__('Email Driver like SMTP, Mailgun, Sendmail, etc.')}}</small>
            </div>
        </div>
        <div class="col-3">
            <div class="form-group">
                <label for="host">Host: <span class="text-danger">*</span></label>
                <input type="text" name="host" id="host" value="{{ old('host', $config->host ?? null) }}" class="form-control">
                <small class="form-text text-muted">{{__('Server Address for outgoing email')}}</small>
            </div>
        </div>

        <div class="col-3">
            <div class="form-group">
                <label for="encripcion">Encryption: <span class="text-danger">*</span></label>
                {{Form::select('encryption', ['tls'=>'TLS','ssl'=>'SSL'], old('host', $config->encryption ?? null), ['class'=>'form-control'] )}}
                <small class="form-text text-muted">{{__('Auth encryption type')}}</small>
            </div>

        </div>
        <div class="col-3">
            <div class="form-group">
                <label for="port">Port: <span class="text-danger">*</span></label>
                <input type="text" name="port" id="port" maxlength="4" value="{{ old('port', $config->port ?? null) }}" class="form-control w-25">
                <small class="form-text text-muted">{{__('Port for the outgoing email server')}}</small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-6">
            <div class="form-group">
                <label for="from_address">From Email:  <span class="text-danger">*</span></label>
                <input type="text" name="from_address" id="from_address" value="{{ old('from_address', $config->from_address ?? null) }}" class="form-control">
                <small class="form-text text-muted">{{__('The email sender address')}}</small>
            </div>
        </div>
        <div class="col-6">
            <div class="form-group">
                <label for="from_name">From Name:  <span class="text-danger">*</span></label>
                <input type="text" name="from_name" id="from_address" value="{{ old('from_name', $config->from_name ?? null) }}" class="form-control">
                <small class="form-text text-muted">{{__('Name of the sender')}}</small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-6">
            <div class="form-group">
                <label for="username">Username: <span class="text-danger">*</span></label>
                <input type="text" name="username" id="username" value="{{ old('username', $config->username ?? null) }}" class="form-control">
                <small class="form-text text-muted">{{__('Authentication username')}}</small>
            </div>
        </div>
        <div class="col-6">
            <div class="form-group">
                <label for="password">Password:  <span class="text-danger">*</span></label>
                <input type="text" name="password" id="password" value="{{ old('password', $config->password ?? null) }}" class="form-control">
                <small class="form-text text-muted">{{__('Account Password')}}</small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-6">
            <label class="radio-inline">
                <input type="radio" name="enabled"
                       id="enabled-1"
                       class="px"
                       value="1" {{(old('enabled', $config->enabled ?? null)) ? 'checked':null}}>
                <span class="lbl">Enabled</span>
            </label>
            <label class="radio-inline">
                <input type="radio" name="enabled"
                       id="enabled-0"
                       class="px"
                       value="0" {{!(old('enabled', $config->enabled ?? null)) ? 'checked':null}}>
                <span class="lbl">Disabled</span>
            </label>
            <small class="form-text text-muted">{{__('Only one configuration can be enabled at a time')}}</small>
        </div>
    </div>
    <input type="hidden" id="id" name="id" value="{{ old('password', $config->id ?? null) }}">
    <br>
    <button type="submit" class="btn btn-primary">Save</button>
</form>
