/**
 * plugins/vuetify.js
 *
 * Framework documentation: https://vuetifyjs.com`
 */

// Styles
import '@mdi/font/css/materialdesignicons.css'
import 'vuetify/styles'

// Composables
import { createVuetify } from 'vuetify'

import { es, en } from 'vuetify/locale'

// https://vuetifyjs.com/en/introduction/why-vuetify/#feature-guides
const vuetify = createVuetify({
  locale: {
    locale: 'es',
    fallback: 'en',
    messages: { es, en}
  },
  theme: {
    themes: {
      light: {
        colors: {
          primary: '#006853',
          secondary: '#bcb096',
          morado: '#8e7cc3',
          rosado: '#c27ba0'
        },
      },
    },
  },
  defaults: {
    VDialog: {
      VCard: { variant: 'elevated' }
    },
    VCard: {
      variant: "outlined",
      VRow: { dense: true },
      VBtn: { variant: 'outlined', color: 'info' },
      VTable: {
        fixedHeader: true,
        density: 'compact',
        variant: 'outlined',
        style: 'min-height:100px;'
      }
    },
    VAutocomplete: {
      density: "compact",
      variant: "outlined",
      itemTitle: "nombre",
      returnObject: true,
      clearable: true
    },
    VSelect: {
      density: "compact",
      variant: "outlined",
      itemTitle: "nombre",
      itemValue: "id",
    },
    VTextField: {
      density: "compact",
      variant: "outlined",
      clearable: true
    },
    VFileInput: {
      density: "compact",
      variant: "outlined"
    },
    VTextarea: {
      density: "compact",
      variant: "outlined"
    },
    VCheckbox: {
      density: "compact",
      hideDetails: true
    }
  },
})

export default vuetify
