/**
 * plugins/index.js
 *
 * Automatically included in `./src/main.js`
 */

// Plugins
import vuetify from '@/plugins/vuetify/vuetify'
import i18n from '@/plugins/i18n'
import pinia from '@/store'
import router from '@/router'
import { loadFonts } from '@/plugins/webfontloader'

export function registerPlugins (app) {
  loadFonts()
  app
    .use(vuetify)
    .use(router)
    .use(i18n)
    .use(pinia)
}
