<?php

namespace EdgarOrozco\LaravelMailconfig\Database\Seeders;

use EdgarOrozco\LaravelMailconfig\Services\PermissionService;
use Illuminate\Database\Seeder;

class PermissionsSeeder extends Seeder
{
    protected $permissionService;

    public function __construct(PermissionService $permissionService)
    {
        $this->permissionService = $permissionService;
    }

    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = $this->permissionService->getPermissions();
        $this->permissionService->createPermissions($permissions);
    }
}
