<?php

namespace EdgarOrozco\LaravelMailconfig\Database\Factories;

use EdgarOrozco\LaravelMailconfig\Models\MailConfig;
use Illuminate\Database\Eloquent\Factories\Factory;

class MailConfigFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = MailConfig::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {

        return [
            'name' => uniqid($this->faker->text(20)),
            'description' => $this->faker->text(200),
            'from_address' => $this->faker->unique()->safeEmail,
            'from_name' => $this->faker->name,
            'driver' => $this->faker->randomElement(['smpt', 'sendmail', 'imap', 'token']),
            'host' => $this->faker->domainName,
            'port' => $this->faker->randomElement(['587', '465', '2525']),
            'username' => $this->faker->userName,
            'password' => $this->faker->password,
            'encryption' => $this->faker->randomElement(['TLS', 'SSL', 'PLAIN']),
            'enabled' => $this->faker->randomElement([true, false]),
        ];
    }
}
