<?php

namespace EdgarOrozco\LaravelMailconfig;

use EdgarOrozco\LaravelMailconfig\Models\MailConfig;
use Illuminate\Support\Facades\Config;

class LaravelMailconfig
{
    /**
     * Establece la configuración de correo de Laravel usando los valores obtenidos de la base de datos.
     *
     * Este método consulta la configuración de correo que está habilitada en la base de datos y establece
     * estos valores como la configuración de correo de Laravel en tiempo de ejecución.
     *
     * Si existe más de una configuración de correo habilitada en la base de datos, se tomará una de forma aleatoria.
     *
     * Esto significa que después de invocar este método, Laravel enviará correos electrónicos utilizando los
     * valores especificados en la base de datos.
     *
     * @return void
     */
    public static function set()
    {

        $cfg = MailConfig::whereEnabled(true)->inRandomOrder()->first();

        if ($cfg) {
            Config::set('mail.mailers.default', $cfg->driver);
            Config::set('mail.mailers.smtp.transport', $cfg->driver);
            Config::set('mail.mailers.smtp.host', $cfg->host);
            Config::set('mail.mailers.smtp.port', $cfg->port);
            Config::set('mail.mailers.smtp.encryption', $cfg->encryption);
            Config::set('mail.mailers.smtp.username', $cfg->username);
            Config::set('mail.mailers.smtp.password', $cfg->password);
            Config::set('mail.mailers.smtp.timeout', $cfg->timeout);
            Config::set('mail.from.address', $cfg->from_address);
            Config::set('mail.from.name', $cfg->from_name);
        }
    }

    public static function disableAll()
    {
        return MailConfig::query()->update(['enabled' => false]);
    }

    /**
     * Obtiene la configuración de correo electrónica que está habilitada.
     *
     * Este método consulta la base de datos y obtiene la configuración de correo electrónica que está habilitada.
     *
     * @return MailConfig Retorna un objeto MailConfig que representa la configuración de correo electrónica habilitada.
     */
    public function getEnabledConfig()
    {
        return MailConfig::enabled();
    }

    /**
     * Obtiene el hash de la configuración de correo electrónica habilitada.
     *
     * Este método consulta la base de datos y obtiene el hash de la configuración de correo electrónica que está habilitada.
     *
     * @return string Retorna un string que representa el hash de la configuración de correo electrónico habilitada.
     */
    public function getHashFromEnabledConfig()
    {
        return MailConfig::hashConfigEnabled();
    }
}
