import {defineStore} from 'pinia';
import apiClient from '@/plugins/axios';
import {ref} from "vue";
import {useLocalStorage, useSessionStorage} from "@vueuse/core";
//import {useLocalStorage} from '@vueuse/core';

export const useMailconfigStore = defineStore('mailconfigs', () => {

  // Estado
  const mailConfig = ref(useSessionStorage('mailconfig', null));

  // Acciones

  async function getMailConfigs(filters){
    try {
      const response = await apiClient.get('/api/mailconfig', {params: filters});
      return response.data;
    } catch (e) {
      console.error(e);
    }
  }

  async function getMailConfig(filters){
    console.log(filters)
    try {
      const response = await apiClient.get('/api/mailconfig?id='+filters.id);
      return response.data;
    } catch (e) {
      console.error(e);
    }
  }
  async function createOrUpdateMailConfig(configData) {
    try {
      const res = await apiClient.post('/api/mailconfig', configData);
      return res.data;
    } catch (e) {
      console.error(e);
    }
  }

  async function deleteMailConfig(id){
    try {
      const res = await apiClient.delete('/api/mailconfig', {
        data: {id: id}
      })
      return res.data;
    } catch (e) {
      console.error(e);
    }
  }


  return {mailConfig, getMailConfigs, getMailConfig, createOrUpdateMailConfig, deleteMailConfig};
}, {
  persist: {
    key: 'mailconfig',

    // Con localStorage la sesión es persistente en el storage del navegador. No se pierden los datos al cerrar el navegador
    //storage: window.localStorage,

    // Con sessionStorage La sesión está asociada a la sesión en el navegador. Si se cierra el navegador los datos de sesión se pierden.
    storage: window.sessionStorage,
  }
});
